/*
 * Decompiled with CFR 0.152.
 */
package com.lynxwork.export.popupMenus;

import adaptorinterface.DomainSpecification;
import com.lynxwork.export.popupMenus.Utils;
import com.lynxwork.rdfexport.DomainWrapper;
import com.lynxwork.rdfexport.VocabularyWrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFErrorHandler;
import org.apache.jena.rdf.model.RDFWriterI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lyo.oslc4j.provider.jena.ErrorHandler;
import vocabulary.Vocabulary;

public class RdfExportService {
    private static final String RDF_LANGUAGE = "Turtle";
    private static final String FILE_EXTENSION = "ttl";

    public void rdfExport(DomainSpecification self) {
        File exportPath = Utils.getTargetFolder((EObject)self);
        if (exportPath == null) {
            return;
        }
        DomainWrapper domainShape = new DomainWrapper(self);
        try {
            Model model = domainShape.getAsRdfModel();
            RDFWriterI writer = model.getWriter(RDF_LANGUAGE);
            writer.setErrorHandler((RDFErrorHandler)new ErrorHandler());
            File file = new File(exportPath, self.getName() + "-shapes.ttl");
            FileOutputStream out = new FileOutputStream(file);
            writer.write(model, (OutputStream)out, null);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String markDown = domainShape.getAsMarkDown(true);
            File mdFile = new File(exportPath, self.getName() + "-shapes.md");
            FileOutputStream out = new FileOutputStream(mdFile);
            out.write(markDown.getBytes());
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void rdfExport(Vocabulary self) {
        File exportPath = Utils.getTargetFolder((EObject)self);
        if (exportPath == null) {
            return;
        }
        VocabularyWrapper vocabularyWrapper = new VocabularyWrapper(self);
        try {
            Model model = vocabularyWrapper.getAsRdfModel();
            RDFWriterI writer = model.getWriter(RDF_LANGUAGE);
            writer.setErrorHandler((RDFErrorHandler)new ErrorHandler());
            File file = new File(exportPath, self.getLabel() + "-vocab.ttl");
            FileOutputStream out = new FileOutputStream(file);
            writer.write(model, (OutputStream)out, null);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

