/*
 * Decompiled with CFR 0.152.
 */
package com.lynxwork.export.popupMenus;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class Utils {
    public static void showMessage(final String title, final String message) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                String[] buttonLabels = new String[]{"OK"};
                MessageDialog dialog = new MessageDialog(shell, title, null, message, 0, buttonLabels, 1);
                dialog.open();
            }
        });
    }

    public static File getModellingProjectBaseFolder(EObject self) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)self);
        URI rootUri = EcoreUtil.getURI((EObject)rootContainer);
        URI resolvedRootUri = CommonPlugin.resolve((URI)rootUri);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath location = Path.fromOSString((String)resolvedRootUri.toFileString());
        IFile ifile = workspace.getRoot().getFileForLocation(location);
        File projectLocation = ifile.getProject().getLocation().toFile();
        return projectLocation;
    }

    public static String promptForFolder(String title, String message, String initialFolder) {
        DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
        dialog.setFilterPath(initialFolder);
        dialog.setMessage(message);
        dialog.setText(title);
        String result = dialog.open();
        return result;
    }

    public static File getTargetFolder(EObject self) {
        File initialFolder = Utils.getModellingProjectBaseFolder(self);
        String targetPath = Utils.promptForFolder("", "", initialFolder.toString());
        if (targetPath == null || targetPath.length() == 0) {
            return null;
        }
        File targetPathFile = new File(targetPath);
        if (!targetPathFile.exists() || !targetPathFile.isDirectory()) {
            Utils.showMessage("Exception!", "Generation path " + targetPath + " must be an existing directory.");
            return null;
        }
        return targetPathFile;
    }

    public static String replaceNewLines(String s) {
        String res = s.replaceAll("(\r\n|\n)", "<br>");
        return res;
    }

    public static String print(String s, String whenEmpty) {
        if (s == null || s.isBlank()) {
            s = whenEmpty;
        }
        s = Utils.replaceNewLines(s);
        return s;
    }
}

