/*
 * Decompiled with CFR 0.152.
 */
package com.lynxwork.export.popupMenus;

import adaptorinterface.AdaptorinterfacePackage;
import adaptorinterface.DomainSpecification;
import adaptorinterface.Specification;
import com.lynxwork.export.popupMenus.Utils;
import com.lynxwork.webexport.CopierWithProxies;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import toolchain.Toolchain;
import toolchain.ToolchainFactory;
import toolchain.ToolchainPackage;
import vocabulary.VocabularyPackage;

public class WebExportService {
    private static Resource createEmptyResource(String fileName) {
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("xml", new XMIResourceFactoryImpl());
        URI uri = URI.createFileURI((String)fileName);
        Resource resource = resSet.createResource(uri);
        return resource;
    }

    private static Resource getSourceResource(String fileName) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        URI uri = URI.createFileURI((String)new File(fileName).getAbsolutePath());
        Resource sourceResource = resourceSet.getResource(uri, true);
        return sourceResource;
    }

    private static void clone(Resource sourceResource, Resource destinationResource) {
        CopierWithProxies copier = new CopierWithProxies(true, true);
        ArrayList copiedSourceContent = (ArrayList)copier.copyAll((Collection)sourceResource.getContents());
        Toolchain toolchain = null;
        if (((EObject)sourceResource.getContents().get(0)).eClass().equals(ToolchainPackage.eINSTANCE.getToolchain())) {
            destinationResource.getContents().addAll((Collection)copiedSourceContent);
            toolchain = (Toolchain)destinationResource.getContents().get(0);
        } else if (((EObject)sourceResource.getContents().get(0)).eClass().equals(AdaptorinterfacePackage.eINSTANCE.getSpecification())) {
            ToolchainFactory factory = ToolchainFactory.eINSTANCE;
            toolchain = factory.createToolchain();
            Specification specification = (Specification)copiedSourceContent.get(0);
            toolchain.setSpecification(specification);
            destinationResource.getContents().add((Object)toolchain);
        } else {
            throw new RuntimeException("Need to handle Other situations");
        }
        copier.setProxies(toolchain);
        copier.copyReferences();
    }

    public void webExport(DomainSpecification self) {
        File exportPath = Utils.getTargetFolder((EObject)self);
        if (exportPath == null) {
            return;
        }
        Resource sourceResource = self.eResource();
        String fileName = new File(exportPath, "webModel.xml").getAbsolutePath();
        Resource destinationResource = WebExportService.createEmptyResource(fileName);
        WebExportService.clone(sourceResource, destinationResource);
        try {
            destinationResource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String SOURCE_FILE_PATH = "C:\\Users\\JadEl-khoury\\git\\lyo\\sysml-oslc-server\\org.oasis.oslcop.sysml.oslc-domain-model\\sysmlDomainSpecification.xml";
        String DEST_FILE_PATH = "C:\\Users\\JadEl-khoury\\git\\lyo\\sysml-oslc-server\\org.oasis.oslcop.sysml.oslc-domain-model\\new.xml";
        EPackage.Registry.INSTANCE.put((Object)"http://org.eclipse.lyo/oslc4j/adaptorInterface", (Object)AdaptorinterfacePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://org.eclipse.lyo/oslc4j/toolChain", (Object)ToolchainPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://org.eclipse.lyo/oslc4j/vocabulary", (Object)VocabularyPackage.eINSTANCE);
        Resource sourceResource = WebExportService.getSourceResource(SOURCE_FILE_PATH);
        Resource destinationResource = WebExportService.createEmptyResource(DEST_FILE_PATH);
        WebExportService.clone(sourceResource, destinationResource);
        try {
            destinationResource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

