/*
 * Decompiled with CFR 0.152.
 */
package com.lynxwork.rdfexport;

import adaptorinterface.DomainSpecification;
import adaptorinterface.Resource;
import adaptorinterface.ResourceProperty;
import com.lynxwork.rdfexport.PropertyWrapper;
import com.lynxwork.rdfexport.ResourceWrapper;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.jena.rdf.model.Model;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.model.Property;
import org.eclipse.lyo.oslc4j.core.model.ResourceShape;
import org.eclipse.lyo.oslc4j.core.model.ValueType;
import org.eclipse.lyo.oslc4j.provider.jena.JenaModelHelper;

public class DomainWrapper {
    private DomainSpecification domainSpecification;
    private Map<String, ResourceWrapper> resourceWrappers;
    private Map<String, PropertyWrapper> propertyWrappers;

    public DomainWrapper(DomainSpecification domainSpecification) {
        this.domainSpecification = domainSpecification;
        this.propertyWrappers = new HashMap<String, PropertyWrapper>();
        for (ResourceProperty resourceProperty : domainSpecification.getResourceProperties()) {
            this.propertyWrappers.put(resourceProperty.getId(), new PropertyWrapper(resourceProperty));
        }
        this.resourceWrappers = new HashMap<String, ResourceWrapper>();
        for (Resource resource : domainSpecification.getResources()) {
            this.resourceWrappers.put(resource.getId(), new ResourceWrapper(resource));
        }
    }

    public Map<String, String> getRelevantNamespaces() {
        HashMap<String, String> relevantNamespaces = new HashMap<String, String>();
        for (ResourceWrapper resourceWrapper : this.resourceWrappers.values()) {
            relevantNamespaces.put(resourceWrapper.getResource().deduceDescribes().getNamespaceURI(), resourceWrapper.getResource().deduceDescribes().getPrefix());
            for (PropertyWrapper propertyWrapper : resourceWrapper.getPropertyWrappers()) {
                relevantNamespaces.put(propertyWrapper.getResourceProperty().deducePropertyDefinition().getNamespaceURI(), propertyWrapper.getResourceProperty().deducePropertyDefinition().getPrefix());
            }
        }
        return relevantNamespaces;
    }

    public Model getAsRdfModel() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, DatatypeConfigurationException, OslcCoreApplicationException {
        ArrayList allResources = new ArrayList();
        this.resourceWrappers.values().forEach(resourceWrapper -> allResources.add(resourceWrapper.getOslcResource()));
        this.propertyWrappers.values().forEach(propertyWrapper -> allResources.add(propertyWrapper.getOslcProperty()));
        Model model = JenaModelHelper.createJenaModel((Object[])allResources.toArray());
        return model;
    }

    public String getAsMarkDown(boolean custom) {
        Object md = "";
        md = (String)md + "# Domain: " + this.domainSpecification.getName() + "\n";
        md = (String)md + "Date of creation: \n\n";
        md = (String)md + "Version number: \n\n";
        md = (String)md + "Revision number: \n\n";
        md = (String)md + "Approved By: \n\n";
        md = (String)md + "Date of approval: \n\n";
        md = (String)md + "Issued by: \n\n";
        md = (String)md + "Referenced Vocabularies: TODO\n\n";
        md = (String)md + "**NamespaceURI**: " + this.domainSpecification.getNamespaceURI() + "\n\n";
        md = (String)md + "**NamespacePrefix**: " + this.domainSpecification.getNamespacePrefix().getName() + "\n\n";
        md = (String)md + "**Other NamespacePrefixes**: \n\n";
        Map<String, String> relevantNamespaces = this.getRelevantNamespaces();
        for (String namespace : relevantNamespaces.keySet()) {
            md = (String)md + "* " + relevantNamespaces.get(namespace) + ": " + namespace + "\n\n";
        }
        md = (String)md + "## Table of Contents\n";
        md = (String)md + "TODO\n\n";
        md = (String)md + "## Scope\n";
        md = (String)md + "## Background\n";
        md = (String)md + "## Constraints\n";
        md = (String)md + "Note: In the constraints below, 'definition of vocabulary class' &  'definition of Vocabulary Property' values correspond to the rdfs:comment values in the vocabularies. \n\n";
        for (ResourceWrapper resourceWrapper : this.resourceWrappers.values()) {
            ResourceShape oslcResource = resourceWrapper.getOslcResource();
            Object label = oslcResource.getTitle();
            if (label == null || ((String)label).isBlank()) {
                label = oslcResource.getName() + " (warning: resource label is missing. displaying resource name instead)";
            }
            md = (String)md + "### " + (String)label + "\n\n";
            md = (String)md + "URI: " + String.valueOf(oslcResource.getAbout()) + "\n\n";
            md = (String)md + "type: Shape\n\n";
            md = (String)md + "target class: " + resourceWrapper.printDescribesRdfTypeAsLink() + "\n\n";
            md = (String)md + "definition of vocabulary class : " + resourceWrapper.printDescribesRdfTypeComment() + "\n\n";
            md = (String)md + "description: " + resourceWrapper.printDescription() + "\n\n";
            if (custom) {
                md = (String)md + "| Prefixed Name | Cardinality | Value-type | Definition of Vocabulary Property | Definition |\n";
                md = (String)md + "|:-------|:--------|:---------|:-----------|:-----------|\n";
            } else {
                md = (String)md + "| Prefixed Name | Occurs | Read-only | Value-type | Representation | Range | Vocabulary Definition | Description |\n";
                md = (String)md + "|:-------|:--|:--|:--|:--|:-------|:-----------|:-----------|\n";
            }
            for (ResourceProperty resourceProperty : resourceWrapper.getResource().getResourceProperties()) {
                PropertyWrapper propertyWrapper = resourceWrapper.getPropertyWrapper(resourceProperty);
                Property oslcProperty = propertyWrapper.getOslcProperty();
                md = (String)md + "| " + propertyWrapper.printPropertyDefinitionAsLink();
                md = custom ? (String)md + "| " + propertyWrapper.printCardinality(true, true) : (String)md + "| " + propertyWrapper.printCardinality(false, false);
                if (custom) {
                    md = ValueType.fromURI((URI)oslcProperty.getValueType()).equals((Object)ValueType.Resource) || ValueType.fromURI((URI)oslcProperty.getValueType()).equals((Object)ValueType.LocalResource) ? (String)md + "| " + propertyWrapper.printRange() : (String)md + "| " + ValueType.fromURI((URI)oslcProperty.getValueType()).name();
                } else {
                    md = (String)md + "| " + String.valueOf(oslcProperty.isReadOnly());
                    md = (String)md + "| " + ValueType.fromURI((URI)oslcProperty.getValueType()).name();
                    md = (String)md + "| " + (propertyWrapper.getResourceProperty().oslcRepresentation() != null ? propertyWrapper.getResourceProperty().oslcRepresentation().name() : "n/a");
                    md = (String)md + "| " + propertyWrapper.printRange();
                }
                if (custom) {
                    md = (String)md + "| " + propertyWrapper.printPropertyDefinitionComment();
                    md = (String)md + "| " + propertyWrapper.printDescription();
                } else {
                    md = (String)md + "| " + propertyWrapper.printDescription();
                    md = (String)md + "| " + propertyWrapper.printAdditionalConstraints();
                }
                md = (String)md + "|\n";
            }
            md = (String)md + "\n";
            md = (String)md + resourceWrapper.printAdditionalConstraints() + "\n\n";
        }
        md = (String)md + "\n";
        return md;
    }
}

