/*
 * Decompiled with CFR 0.152.
 */
package com.lynxwork.rdfexport;

import adaptorinterface.Resource;
import adaptorinterface.ResourceProperty;
import com.lynxwork.export.popupMenus.Utils;
import com.lynxwork.rdfexport.ResourceWrapper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lyo.oslc4j.core.model.Property;

public class PropertyWrapper {
    Property oslcProperty;
    ResourceProperty resourceProperty;
    List<ResourceWrapper> rangeResourceWrappers;

    public PropertyWrapper(ResourceProperty resourceProperty) {
        this.resourceProperty = resourceProperty;
        this.oslcProperty = new Property();
        this.oslcProperty.setAbout(resourceProperty.getPropertyShapeURI());
        this.oslcProperty.setName(resourceProperty.getName());
        this.oslcProperty.setOccurs(resourceProperty.oslcCardinality());
        this.oslcProperty.setReadOnly(Boolean.valueOf(resourceProperty.isReadOnly()));
        this.oslcProperty.setValueType(resourceProperty.oslcValueType());
        this.oslcProperty.setRepresentation(resourceProperty.oslcRepresentation());
        this.rangeResourceWrappers = new ArrayList<ResourceWrapper>();
        for (Resource range : resourceProperty.getRange()) {
            ResourceWrapper resourceWrapper = new ResourceWrapper(range, false);
            this.rangeResourceWrappers.add(resourceWrapper);
            this.oslcProperty.addRange(range.deduceDescribesAsUri());
        }
        this.oslcProperty.setDescription(resourceProperty.getDescription());
        this.oslcProperty.setPropertyDefinition(resourceProperty.deducePropertyDefinitionAsUri());
    }

    public Property getOslcProperty() {
        return this.oslcProperty;
    }

    public ResourceProperty getResourceProperty() {
        return this.resourceProperty;
    }

    public String printCardinality(boolean numeric, boolean additionalConstraints) {
        Object s = "";
        s = (String)s + (numeric ? this.resourceProperty.getOccurs().toStringNumeric() : this.resourceProperty.getOccurs().toString());
        if (additionalConstraints && this.resourceProperty.getAdditionalConstraints() != null) {
            s = (String)s + " <br>";
            s = (String)s + Utils.replaceNewLines(this.resourceProperty.getAdditionalConstraints());
        }
        return s;
    }

    public String printRange() {
        if (this.rangeResourceWrappers.size() == 0) {
            return "n/a";
        }
        if (this.rangeResourceWrappers.size() == 1) {
            return this.rangeResourceWrappers.get(0).printDescribesRdfTypeAsLink();
        }
        Object md = "<ul>";
        for (ResourceWrapper rangeResourceWrapper : this.rangeResourceWrappers) {
            md = (String)md + "<li>" + rangeResourceWrapper.printDescribesRdfTypeAsLink() + "</li>";
        }
        md = (String)md + "</ul>";
        return md;
    }

    public String printPropertyDefinitionAsLink() {
        Object s = "";
        s = (String)s + "[" + this.resourceProperty.toString(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)) + "]";
        s = (String)s + "(";
        s = (String)s + String.valueOf(this.resourceProperty.deducePropertyDefinitionAsUri());
        s = (String)s + ")";
        return s;
    }

    public String printDescription() {
        return Utils.print(this.oslcProperty.getDescription(), "n/a");
    }

    public String printAdditionalConstraints() {
        return Utils.print(this.resourceProperty.getAdditionalConstraints(), "n/a");
    }

    public String printPropertyDefinitionComment() {
        return Utils.print(this.resourceProperty.deducePropertyDefinitionComment(), "n/a");
    }
}

