/*
 * Decompiled with CFR 0.152.
 */
package com.lynxwork.rdfexport;

import adaptorinterface.Resource;
import adaptorinterface.ResourceProperty;
import com.lynxwork.export.popupMenus.Utils;
import com.lynxwork.rdfexport.PropertyWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.lyo.oslc4j.core.model.Property;
import org.eclipse.lyo.oslc4j.core.model.ResourceShape;

public class ResourceWrapper {
    ResourceShape oslcResource;
    Resource resource;
    Map<String, PropertyWrapper> propertyWrappers;
    boolean withProperties;

    public ResourceWrapper(Resource resource) {
        this(resource, true);
    }

    public ResourceWrapper(Resource resource, boolean withProperties) {
        this.resource = resource;
        this.oslcResource = new ResourceShape();
        this.withProperties = withProperties;
        this.oslcResource.setAbout(resource.getResourceShapeURI());
        this.oslcResource.setName(resource.getName());
        this.oslcResource.setTitle(resource.getTitle());
        this.oslcResource.setDescription(resource.getDescription());
        this.oslcResource.setDescribes(new URI[]{resource.deduceDescribesAsUri()});
        if (withProperties) {
            this.propertyWrappers = new HashMap<String, PropertyWrapper>();
            ArrayList<Property> properties = new ArrayList<Property>();
            for (ResourceProperty resourceProperty : resource.getResourceProperties()) {
                PropertyWrapper propertyWrapper = new PropertyWrapper(resourceProperty);
                this.propertyWrappers.put(resourceProperty.getId(), propertyWrapper);
                properties.add(propertyWrapper.getOslcProperty());
            }
            Property[] ps = new Property[properties.size()];
            this.oslcResource.setProperties(properties.toArray(ps));
        }
    }

    public Resource getResource() {
        return this.resource;
    }

    public ResourceShape getOslcResource() {
        return this.oslcResource;
    }

    public PropertyWrapper getPropertyWrapper(ResourceProperty resourceProperty) {
        if (!this.withProperties) {
            throw new IllegalStateException("ResourceWrapper was constructed without its properties");
        }
        return this.propertyWrappers.get(resourceProperty.getId());
    }

    public Collection<PropertyWrapper> getPropertyWrappers() {
        if (!this.withProperties) {
            throw new IllegalStateException("ResourceWrapper was constructed without its properties");
        }
        return this.propertyWrappers.values();
    }

    public String printDescription() {
        return Utils.print(this.resource.getDescription(), "n/a");
    }

    public String printAdditionalConstraints() {
        if (this.resource.getAdditionalConstraints().size() == 0) {
            return "";
        }
        Object s = "";
        s = (String)s + "Additional Constraints:\n\n";
        s = (String)s + "<ul>\n";
        for (String c : this.resource.getAdditionalConstraints()) {
            s = (String)s + "<li>" + c + "</li>\n";
        }
        s = (String)s + "</ul>\n";
        return s;
    }

    public String printDescribesRdfTypeAsLink() {
        Object s = "";
        s = (String)s + "[" + this.resource.toString(Boolean.valueOf(false), Boolean.valueOf(true)) + "]";
        s = (String)s + "(";
        s = (String)s + String.valueOf(this.resource.deduceDescribesAsUri());
        s = (String)s + ")";
        return s;
    }

    public String printDescribesRdfTypeComment() {
        return Utils.print(this.resource.deduceDescribesComment(), "n/a");
    }
}

