/*
 * Decompiled with CFR 0.152.
 */
package com.lynxwork.rdfexport;

import java.lang.reflect.InvocationTargetException;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import vocabulary.Class;
import vocabulary.Property;
import vocabulary.Vocabulary;

public class VocabularyWrapper {
    private Vocabulary vocabulary;

    public VocabularyWrapper(Vocabulary vocabulary) {
        this.vocabulary = vocabulary;
    }

    public Model getAsRdfModel() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, DatatypeConfigurationException, OslcCoreApplicationException {
        Resource r;
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("rdf", RDF.getURI());
        model.setNsPrefix("rdfs", RDFS.getURI());
        for (Class c : this.vocabulary.getClasses()) {
            r = model.createResource(this.vocabulary.getNamespaceURI() + c.getName()).addProperty(RDF.type, (RDFNode)RDFS.Class).addProperty(RDFS.label, c.getLabel());
            if (c.getComment() == null) continue;
            r.addProperty(RDFS.comment, c.getComment());
        }
        for (Property p : this.vocabulary.getProperties()) {
            r = model.createResource(this.vocabulary.getNamespaceURI() + p.getName()).addProperty(RDF.type, (RDFNode)RDF.Property).addProperty(RDFS.label, p.getLabel());
            if (p.getComment() == null) continue;
            r.addProperty(RDFS.comment, p.getComment());
        }
        return model;
    }
}

