/*
 * Decompiled with CFR 0.152.
 */
package com.lynxwork.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TypeParserService {
    public static List<Object> parseTypeAsList(String typeString) {
        ParsedType pt = TypeParserService.parseType(typeString);
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(pt.getBaseClass());
        result.add(pt.isArray());
        result.add(pt.getTypeParameters().size() > 0);
        result.add(pt.getTypeParameters());
        return result;
    }

    public static Map<String, Object> parseTypeAsMap(String typeString) {
        ParsedType pt = TypeParserService.parseType(typeString);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("baseClass", pt.getBaseClass());
        result.put("isArray", pt.isArray());
        result.put("isParameterized", pt.getTypeParameters().size() > 0);
        result.put("typeParameters", pt.getTypeParameters());
        return result;
    }

    public static ParsedType parseType(String typeString) {
        int lt;
        String trimmed = typeString.trim();
        boolean isArray = false;
        if (trimmed.endsWith("[]")) {
            isArray = true;
            trimmed = trimmed.substring(0, trimmed.length() - 2).trim();
        }
        if ((lt = trimmed.indexOf(60)) != -1) {
            String base = trimmed.substring(0, lt).trim();
            String inside = trimmed.substring(lt + 1, trimmed.lastIndexOf(62)).trim();
            List<String> params = TypeParserService.splitParameters(inside);
            return new ParsedType(base, isArray, params);
        }
        return new ParsedType(trimmed, isArray, Collections.emptyList());
    }

    private static List<String> splitParameters(String inside) {
        String[] parts = inside.split(",");
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            String clean = p.trim();
            if (!clean.isEmpty()) {
                result.add(clean);
            }
            ++n2;
        }
        return result;
    }

    public static class ParsedType {
        private final String baseClass;
        private final boolean isArray;
        private final List<String> typeParameters;

        public ParsedType(String baseClass, boolean isArray, List<String> typeParameters) {
            this.baseClass = baseClass;
            this.isArray = isArray;
            this.typeParameters = typeParameters;
        }

        public String getBaseClass() {
            return this.baseClass;
        }

        public boolean isArray() {
            return this.isArray;
        }

        public List<String> getTypeParameters() {
            return this.typeParameters;
        }
    }
}

