/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphMemFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.TripleBoundary;
import org.apache.jena.util.CollectionFactory;
import org.apache.jena.util.iterator.ExtendedIterator;

public class GraphExtract {
    protected final TripleBoundary b;

    public GraphExtract(TripleBoundary b) {
        this.b = b;
    }

    public Graph extract(Node node, Graph graph) {
        return this.extractInto(GraphMemFactory.createGraphMem(), node, graph);
    }

    public Graph extractInto(Graph toUpdate, Node root, Graph extractFrom) {
        new Extraction(this.b, toUpdate, extractFrom).extractInto(root);
        return toUpdate;
    }

    protected static class Extraction {
        protected Graph toUpdate;
        protected Graph extractFrom;
        protected Set<Node> active;
        protected TripleBoundary b;

        Extraction(TripleBoundary b, Graph toUpdate, Graph extractFrom) {
            this.toUpdate = toUpdate;
            this.extractFrom = extractFrom;
            this.active = CollectionFactory.createHashedSet();
            this.b = b;
        }

        public void extractInto(Node root) {
            this.active.add(root);
            ExtendedIterator<Triple> it = this.extractFrom.find(root, Node.ANY, Node.ANY);
            while (it.hasNext()) {
                Triple t = (Triple)it.next();
                Node subRoot = t.getObject();
                this.toUpdate.add(t);
                if (this.active.contains(subRoot) || this.b.stopAt(t)) continue;
                this.extractInto(subRoot);
            }
        }
    }
}

