/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.base.file;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.tdb.base.block.Block;
import org.apache.jena.tdb.base.file.BlockAccess;
import org.apache.jena.tdb.base.file.FileException;
import org.apache.jena.tdb.sys.SystemTDB;

public class BlockAccessMem
implements BlockAccess {
    public static boolean SafeMode = true;
    static final boolean Checking = true;
    boolean fileClosed = false;
    private List<Block> blocks = new ArrayList<Block>();
    private final boolean safeModeThisMgr;
    protected final int blockSize;
    private final String label;

    public BlockAccessMem(String label, int blockSize) {
        this(label, blockSize, SafeMode);
    }

    private BlockAccessMem(String label, int blockSize, boolean b) {
        this.blockSize = blockSize;
        this.label = label;
        this.safeModeThisMgr = b;
    }

    @Override
    public Block allocate(int blkSize) {
        if (blkSize > 0 && blkSize != this.blockSize) {
            throw new FileException("Fixed blocksize only: request= " + blkSize + " / fixed size=" + this.blockSize);
        }
        int x = this.blocks.size();
        ByteBuffer bb = ByteBuffer.allocate(blkSize);
        Block block = new Block(x, bb);
        this.blocks.add(block);
        return block;
    }

    @Override
    public Block read(long id) {
        this.check(id);
        Block blk = this.blocks.get((int)id);
        if (this.safeModeThisMgr) {
            return blk.replicate();
        }
        return blk;
    }

    @Override
    public void write(Block block) {
        this.check(block);
        this._write(block);
    }

    @Override
    public void overwrite(Block block) {
        this.write(block);
    }

    private void _write(Block block) {
        if (this.safeModeThisMgr) {
            block = block.replicate();
        }
        this.blocks.set(block.getId().intValue(), block);
    }

    @Override
    public boolean isEmpty() {
        return this.blocks.isEmpty();
    }

    @Override
    public boolean valid(long id) {
        return id >= 0L && id < (long)this.blocks.size();
    }

    public void close() {
        this.fileClosed = true;
    }

    public void sync() {
    }

    private void check(Block block) {
        this.check(block.getId());
        this.check(block.getByteBuffer());
    }

    private void check(long id) {
        if (id > Integer.MAX_VALUE) {
            throw new FileException("BlockAccessMem: Bounds exception (id large than an int): " + id);
        }
        if (id < 0L || id >= (long)this.blocks.size()) {
            throw new FileException("BlockAccessMem: Bounds exception: " + id);
        }
    }

    private void check(ByteBuffer bb) {
        if (bb.capacity() != this.blockSize) {
            throw new FileException(String.format("FileAccessMem: Wrong size block.  Expected=%d : actual=%d", this.blockSize, bb.capacity()));
        }
        if (bb.order() != SystemTDB.NetworkOrder) {
            throw new FileException("BlockMgrMem: Wrong byte order");
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return "Mem:" + this.label;
    }
}

