/*
 * Decompiled with CFR 0.152.
 */
package oslcserver;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RestSourceDataFormat implements Enumerator
{
    JSON(0, "JSON", "JSON"),
    XML(1, "XML", "XML");

    public static final int JSON_VALUE = 0;
    public static final int XML_VALUE = 1;
    private static final RestSourceDataFormat[] VALUES_ARRAY;
    public static final List<RestSourceDataFormat> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RestSourceDataFormat[]{JSON, XML};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RestSourceDataFormat get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RestSourceDataFormat result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RestSourceDataFormat getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RestSourceDataFormat result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RestSourceDataFormat get(int value) {
        switch (value) {
            case 0: {
                return JSON;
            }
            case 1: {
                return XML;
            }
        }
        return null;
    }

    private RestSourceDataFormat(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

