/*
 * Decompiled with CFR 0.152.
 */
package oslcserver;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RestSourceModelType implements Enumerator
{
    JSON_SCHEMA(0, "JSON_SCHEMA", "JSON Schema"),
    JSON_EXAMPLE(1, "JSON_EXAMPLE", "JSON Example"),
    OPENAPI(2, "OPENAPI", "OpenAPI");

    public static final int JSON_SCHEMA_VALUE = 0;
    public static final int JSON_EXAMPLE_VALUE = 1;
    public static final int OPENAPI_VALUE = 2;
    private static final RestSourceModelType[] VALUES_ARRAY;
    public static final List<RestSourceModelType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RestSourceModelType[]{JSON_SCHEMA, JSON_EXAMPLE, OPENAPI};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RestSourceModelType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RestSourceModelType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RestSourceModelType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RestSourceModelType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RestSourceModelType get(int value) {
        switch (value) {
            case 0: {
                return JSON_SCHEMA;
            }
            case 1: {
                return JSON_EXAMPLE;
            }
            case 2: {
                return OPENAPI;
            }
        }
        return null;
    }

    private RestSourceModelType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

