/*
 * Decompiled with CFR 0.152.
 */
package com.lynxwork.oslc.design.wizard;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class OperationSelectionPage
extends WizardPage {
    private Map<Operation, Button> operationChoices;
    private Composite container;

    public OperationSelectionPage() {
        super("Operation Selection");
        this.setTitle("Operation Selection");
        this.setDescription("Select the web operations to support");
        this.operationChoices = new HashMap<Operation, Button>();
    }

    private Button createCheckBox(Composite parent, String text, boolean defaultValue, int boundX, int boundY, int boundWidth, int boundHeight) {
        Button check = new Button(parent, 32);
        check.setText(text);
        check.setSelection(defaultValue);
        check.setBounds(boundX, boundY, boundWidth, boundHeight);
        return check;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 2;
        Group group1 = new Group(this.container, 16);
        group1.setText("OSLC Services");
        group1.setSize(300, 150);
        this.operationChoices.put(Operation.QUERY_CAPABILITY, this.createCheckBox((Composite)group1, "Query Capability", true, 10, 25, 150, 20));
        this.operationChoices.put(Operation.SELECTION_DIALOG, this.createCheckBox((Composite)group1, "Selection Dialog", true, 10, 50, 150, 20));
        this.operationChoices.put(Operation.CREATION_FACTORY, this.createCheckBox((Composite)group1, "Creation Factory", false, 10, 75, 150, 20));
        this.operationChoices.put(Operation.CREATION_DIALOG, this.createCheckBox((Composite)group1, "Creation Dialog", false, 10, 100, 150, 20));
        Group group2 = new Group(this.container, 16);
        group2.setText("CRUD Services");
        group2.setSize(300, 150);
        this.operationChoices.put(Operation.READ, this.createCheckBox((Composite)group2, "Read", true, 10, 25, 150, 20));
        this.operationChoices.put(Operation.UPDATE, this.createCheckBox((Composite)group2, "Update", false, 10, 50, 150, 20));
        this.operationChoices.put(Operation.DELETE, this.createCheckBox((Composite)group2, "Delete", false, 10, 75, 150, 20));
        this.setControl((Control)this.container);
        this.setPageComplete(true);
    }

    public Map<Operation, Boolean> getUserChoices() {
        HashMap<Operation, Boolean> results = new HashMap();
        results = this.operationChoices.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Button)e.getValue()).getSelection()));
        return results;
    }

    public static enum Operation {
        SELECTION_DIALOG,
        CREATION_DIALOG,
        QUERY_CAPABILITY,
        CREATION_FACTORY,
        READ,
        UPDATE,
        DELETE;

    }
}

