/*
 * Decompiled with CFR 0.152.
 */
package com.lynxwork.oslc.design.wizard;

import adaptorinterface.AdaptorInterface;
import adaptorinterface.AdaptorinterfaceFactory;
import adaptorinterface.DomainSpecification;
import adaptorinterface.QueryCapability;
import adaptorinterface.Resource;
import adaptorinterface.Service;
import adaptorinterface.ServiceProvider;
import adaptorinterface.ServiceProviderCatalog;
import adaptorinterface.WebService;
import com.lynxwork.oslc.design.wizard.OperationSelectionPage;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public class ServiceCreationWizard
extends Wizard {
    protected OperationSelectionPage two;
    private Resource targetResource;
    private AdaptorInterface adaptorInterface;

    public ServiceCreationWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public ServiceCreationWizard(Resource targetResource, AdaptorInterface adaptorInterface) {
        this();
        this.targetResource = targetResource;
        this.adaptorInterface = adaptorInterface;
    }

    public void showServiceCreationWizard(EObject selectedElement, AdaptorInterface adaptorInterface) {
    }

    public void showServiceCreationWizard(Resource targetResource, AdaptorInterface adaptorInterface) {
        if (targetResource == null || adaptorInterface == null) {
            return;
        }
        this.targetResource = targetResource;
        this.adaptorInterface = adaptorInterface;
        WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)new ServiceCreationWizard(targetResource, adaptorInterface));
        wizardDialog.open();
    }

    public String getWindowTitle() {
        return "Create Services";
    }

    public void addPages() {
        this.two = new OperationSelectionPage();
        this.addPage((IWizardPage)this.two);
    }

    public boolean performFinish() {
        ServiceProvider serviceProvider;
        AdaptorinterfaceFactory factory = AdaptorinterfaceFactory.eINSTANCE;
        ServiceProviderCatalog serviceProviderCatalog = this.adaptorInterface.getServiceProviderCatalog();
        if (serviceProviderCatalog == null) {
            serviceProviderCatalog = factory.createServiceProviderCatalog();
            this.adaptorInterface.setServiceProviderCatalog(serviceProviderCatalog);
            serviceProviderCatalog.setTitle("Service Provider Catalog");
            serviceProviderCatalog.setDescription("Service Provider Catalog");
        }
        if (serviceProviderCatalog.getServiceProviders().size() == 0) {
            serviceProvider = factory.createServiceProvider();
            serviceProviderCatalog.getServiceProviders().add((Object)serviceProvider);
            serviceProvider.setTitle("Service Provider");
            serviceProvider.setDescription("Service Provider");
        }
        serviceProvider = (ServiceProvider)serviceProviderCatalog.getServiceProviders().get(0);
        Map<OperationSelectionPage.Operation, Boolean> userChoices = this.two.getUserChoices();
        if (userChoices.get((Object)OperationSelectionPage.Operation.QUERY_CAPABILITY).booleanValue() || userChoices.get((Object)OperationSelectionPage.Operation.CREATION_FACTORY).booleanValue() || userChoices.get((Object)OperationSelectionPage.Operation.CREATION_DIALOG).booleanValue() || userChoices.get((Object)OperationSelectionPage.Operation.SELECTION_DIALOG).booleanValue()) {
            QueryCapability capability;
            Service newService = factory.createService();
            serviceProvider.getServices().add((Object)newService);
            newService.setDomainSpecification((DomainSpecification)this.targetResource.eContainer());
            if (userChoices.get((Object)OperationSelectionPage.Operation.QUERY_CAPABILITY).booleanValue()) {
                capability = factory.createQueryCapability();
                newService.getQueryCapabilities().add((Object)capability);
                capability.setLabel("Query Capability for " + this.targetResource.getName());
                capability.setTitle(capability.getLabel());
                capability.setQueryBaseURI("query");
                capability.getResourceTypes().add((Object)this.targetResource);
            }
            if (userChoices.get((Object)OperationSelectionPage.Operation.CREATION_FACTORY).booleanValue()) {
                capability = factory.createCreationFactory();
                newService.getCreationFactories().add((Object)capability);
                capability.setLabel("Creation Factory for " + this.targetResource.getName());
                capability.setTitle(capability.getLabel());
                capability.setCreationURI("create");
                capability.getResourceTypes().add((Object)this.targetResource);
            }
            if (userChoices.get((Object)OperationSelectionPage.Operation.SELECTION_DIALOG).booleanValue()) {
                capability = factory.createDialog();
                newService.getSelectionDialogs().add((Object)capability);
                capability.setLabel("Selection Dialog for " + this.targetResource.getName());
                capability.setTitle(capability.getLabel());
                capability.setDialogURI("selector");
                capability.setHintWidth((short)750);
                capability.setHintHeight((short)750);
                capability.getResourceTypes().add((Object)this.targetResource);
            }
            if (userChoices.get((Object)OperationSelectionPage.Operation.CREATION_DIALOG).booleanValue()) {
                capability = factory.createDialog();
                newService.getCreationDialogs().add((Object)capability);
                capability.setLabel("Creation Dialog for " + this.targetResource.getName());
                capability.setTitle(capability.getLabel());
                capability.setDialogURI("creator");
                capability.setHintWidth((short)250);
                capability.setHintHeight((short)250);
                capability.getResourceTypes().add((Object)this.targetResource);
            }
        }
        if (userChoices.get((Object)OperationSelectionPage.Operation.READ).booleanValue() || userChoices.get((Object)OperationSelectionPage.Operation.UPDATE).booleanValue() || userChoices.get((Object)OperationSelectionPage.Operation.DELETE).booleanValue()) {
            WebService webService = factory.createWebService();
            this.adaptorInterface.getWebServices().add((Object)webService);
            webService.setName(this.targetResource.getName().substring(0, 1).toUpperCase() + this.targetResource.getName().substring(1) + "Service");
            webService.setServiceUrlPattern(webService.getName().substring(0, 1).toLowerCase() + webService.getName().substring(1));
            webService.setResourceUrlPattern("[ResourceType]/{id}");
            webService.setRead(userChoices.get((Object)OperationSelectionPage.Operation.READ).booleanValue());
            webService.setUpdate(userChoices.get((Object)OperationSelectionPage.Operation.UPDATE).booleanValue());
            webService.setDelete(userChoices.get((Object)OperationSelectionPage.Operation.DELETE).booleanValue());
            webService.getResourceTypes().add((Object)this.targetResource);
        }
        return true;
    }
}

