/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.api.command.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.tools.api.Messages;

public abstract class AbstractZOrderRecordingCommand
extends RecordingCommand {
    protected List<? extends View> elementsToMove;
    protected View containerView;

    public AbstractZOrderRecordingCommand(TransactionalEditingDomain domain, List<? extends View> elementsToMove) {
        super(domain);
        if (elementsToMove != null && elementsToMove.size() > 1) {
            this.setLabel(this.getCommandLabelForSeveralElements());
        } else {
            this.setLabel(this.getCommandLabelForOneElement());
        }
        if (elementsToMove.isEmpty()) {
            throw new IllegalArgumentException(Messages.ZOrderRecordingCommand_emptyList);
        }
        this.containerView = (View)elementsToMove.get(0).eContainer();
        if (!elementsToMove.stream().allMatch(view -> this.containerView.equals(view.eContainer()))) {
            throw new IllegalArgumentException(Messages.ZOrderRecordingCommand_notSameParent);
        }
        if (!elementsToMove.stream().allMatch(view -> view instanceof Node) && !elementsToMove.stream().allMatch(view -> view instanceof Edge)) {
            throw new IllegalArgumentException(Messages.ZOrderRecordingCommand_notSameType);
        }
        this.elementsToMove = this.sortSelection(elementsToMove);
    }

    protected abstract String getCommandLabelForOneElement();

    protected abstract String getCommandLabelForSeveralElements();

    protected List<? extends View> sortSelection(List<? extends View> viewsToSort) {
        if (viewsToSort.size() < 2) {
            return viewsToSort;
        }
        ArrayList<? extends View> toReturn = new ArrayList<View>(viewsToSort.size());
        toReturn.addAll(viewsToSort);
        if (viewsToSort.get(0) instanceof Edge) {
            Collections.sort(toReturn, new EdgeComparator());
        } else if (viewsToSort.get(0) instanceof Edge) {
            Collections.sort(toReturn, new NodeComparator());
        }
        return toReturn;
    }

    protected List<? extends View> reverseSortSelection(List<? extends View> viewsToSort) {
        List<? extends View> toReturn = this.sortSelection(viewsToSort);
        Collections.reverse(toReturn);
        return toReturn;
    }

    private class EdgeComparator
    implements Comparator<View> {
        private EdgeComparator() {
        }

        @Override
        public int compare(View view0, View view1) {
            Diagram parent = (Diagram)view0.eContainer();
            int view0Index = parent.getEdges().indexOf((Object)view0);
            int view1Index = parent.getEdges().indexOf((Object)view1);
            return view0Index - view1Index;
        }
    }

    private class NodeComparator
    implements Comparator<View> {
        private NodeComparator() {
        }

        @Override
        public int compare(View view0, View view1) {
            Diagram parent = (Diagram)view0.eContainer();
            int view0Index = parent.getChildren().indexOf((Object)view0);
            int view1Index = parent.getChildren().indexOf((Object)view1);
            return view0Index - view1Index;
        }
    }
}

