/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.label;

import com.google.common.eventbus.Subscribe;
import java.util.EventObject;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.compare.command.ICompareCommandStack;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.ICompareEditingDomainChange;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class LabelContentViewer
extends Viewer
implements IPropertyChangeNotifier,
CommandStackListener {
    private final Composite control;
    private final ListenerList listenerList;
    private Object input;
    private final EMFCompareConfiguration configuration;
    private boolean dirty;

    public LabelContentViewer(Composite parent, String title, String message, EMFCompareConfiguration configuration) {
        this.configuration = configuration;
        this.control = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        this.control.setLayout((Layout)layout);
        Label label = new Label(this.control, 0);
        label.setText(message);
        label.setFont(JFaceResources.getBannerFont());
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        this.control.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)title);
        ToolBarManager toolBarManager = CompareViewerPane.getToolBarManager((Composite)parent);
        if (toolBarManager != null) {
            toolBarManager.removeAll();
        }
        this.listenerList = new ListenerList();
        this.editingDomainChange(null, configuration.getEditingDomain());
        configuration.getEventBus().register((Object)this);
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LabelContentViewer.this.handleDisposed();
            }
        });
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public void refresh() {
    }

    public ISelection getSelection() {
        return StructuredSelection.EMPTY;
    }

    public Object getInput() {
        return this.input;
    }

    public Control getControl() {
        return this.control;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerList.remove((Object)listener);
    }

    @Subscribe
    public void editingDomainChange(ICompareEditingDomainChange event) {
        ICompareEditingDomain oldValue = event.getOldValue();
        ICompareEditingDomain newValue = event.getNewValue();
        this.editingDomainChange(oldValue, newValue);
    }

    public void editingDomainChange(ICompareEditingDomain oldValue, ICompareEditingDomain newValue) {
        ICompareCommandStack commandStack;
        if (oldValue != null) {
            commandStack = oldValue.getCommandStack();
            commandStack.removeCommandStackListener((CommandStackListener)this);
        }
        if (newValue != oldValue && newValue != null) {
            commandStack = newValue.getCommandStack();
            commandStack.addCommandStackListener((CommandStackListener)this);
            this.setDirty(commandStack.isLeftSaveNeeded() || commandStack.isRightSaveNeeded());
        }
    }

    protected void setDirty(boolean dirty) {
        if (this.dirty != dirty) {
            this.dirty = dirty;
            Utilities.firePropertyChange((ListenerList)this.listenerList, (Object)((Object)this), (String)"DIRTY_STATE", null, (Object)dirty);
        }
    }

    public void commandStackChanged(EventObject event) {
        if (this.configuration.getEditingDomain() != null) {
            ICompareCommandStack commandStack = this.configuration.getEditingDomain().getCommandStack();
            this.setDirty(commandStack.isLeftSaveNeeded() || commandStack.isRightSaveNeeded());
        }
    }

    protected void handleDisposed() {
        this.configuration.getEventBus().unregister((Object)this);
        this.configuration.disposeListeners();
        this.editingDomainChange(this.configuration.getEditingDomain(), null);
    }
}

