/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.provider.jena;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Providers;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFErrorHandler;
import org.apache.jena.rdf.model.RDFReaderI;
import org.apache.jena.rdf.model.RDFWriterI;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.exception.MessageExtractor;
import org.eclipse.lyo.oslc4j.core.model.Error;
import org.eclipse.lyo.oslc4j.core.model.OslcMediaType;
import org.eclipse.lyo.oslc4j.core.model.ResponseInfo;
import org.eclipse.lyo.oslc4j.core.model.ResponseInfoArray;
import org.eclipse.lyo.oslc4j.core.model.ServiceProvider;
import org.eclipse.lyo.oslc4j.core.model.ServiceProviderCatalog;
import org.eclipse.lyo.oslc4j.provider.jena.ErrorHandler;
import org.eclipse.lyo.oslc4j.provider.jena.JenaModelHelper;
import org.eclipse.lyo.oslc4j.provider.jena.ProviderHelper;
import org.eclipse.lyo.oslc4j.provider.jena.RdfXmlAbbreviatedWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOslcRdfXmlProvider {
    private static final Logger log = LoggerFactory.getLogger((String)AbstractOslcRdfXmlProvider.class.getName());
    @Deprecated
    public static final String OSLC4J_ALWAYS_XML_ABBREV = "org.eclipse.lyo.oslc4j.alwaysXMLAbbrev";
    @Deprecated
    public static final String OSLC4J_STRICT_DATATYPES = "org.eclipse.lyo.oslc4j.strictDatatypes";
    private static final Annotation[] ANNOTATIONS_EMPTY_ARRAY = new Annotation[0];
    private static final Class<Error> CLASS_OSLC_ERROR = Error.class;
    private static final ErrorHandler ERROR_HANDLER = new ErrorHandler();
    @Context
    private HttpHeaders httpHeaders;
    @Context
    protected HttpServletRequest httpServletRequest;
    @Context
    private Providers providers;

    protected AbstractOslcRdfXmlProvider() {
    }

    protected void writeTo(Object[] objects, MediaType baseMediaType, MultivaluedMap<String, Object> map, OutputStream outputStream, Map<String, Object> properties, String descriptionURI, String responseInfoURI, ResponseInfo<?> responseInfo) throws WebApplicationException {
        String serializationLanguage = this.getSerializationLanguage(baseMediaType);
        if (objects != null && objects[0] != null && (objects[0] instanceof ServiceProviderCatalog || objects[0] instanceof ServiceProvider) && serializationLanguage.equals("RDF/XML") && "true".equals(System.getProperty("org.eclipse.lyo.oslc4j.alwaysXMLAbbrevOnlyProviders"))) {
            serializationLanguage = "RDF/XML-ABBREV";
            log.info("Using RDF/XML-ABBREV for ServiceProvider resources");
        }
        this.writeObjectsTo(objects, outputStream, properties, descriptionURI, responseInfoURI, responseInfo, serializationLanguage);
    }

    private void writeObjectsTo(Object[] objects, OutputStream outputStream, Map<String, Object> properties, String descriptionURI, String responseInfoURI, ResponseInfo<?> responseInfo, String serializationLanguage) {
        try {
            Instant start = Instant.now();
            Model model = JenaModelHelper.createJenaModel((String)descriptionURI, (String)responseInfoURI, responseInfo, (Object[])objects, properties);
            RDFWriterI writer = this.getRdfWriter(serializationLanguage, model);
            if (serializationLanguage.equals("RDF/XML") || serializationLanguage.equals("RDF/XML-ABBREV")) {
                writer.setProperty("showXmlDeclaration", (Object)"false");
                String xmlDeclaration = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
                outputStream.write(xmlDeclaration.getBytes());
            }
            writer.write(model, outputStream, null);
            Instant finish = Instant.now();
            log.trace("writeObjectsTo - Execution Duration: {} ms", (Object)Duration.between(start, finish).toMillis());
        }
        catch (Exception exception) {
            log.warn(MessageExtractor.getMessage((String)"ErrorSerializingResource"));
            throw new IllegalStateException(exception);
        }
    }

    private RDFWriterI getRdfWriter(String serializationLanguage, Model model) {
        RdfXmlAbbreviatedWriter writer = serializationLanguage.equals("RDF/XML-ABBREV") ? new RdfXmlAbbreviatedWriter() : model.getWriter(serializationLanguage);
        writer.setProperty("showXmlDeclaration", "false");
        writer.setErrorHandler(ERROR_HANDLER);
        return writer;
    }

    protected void writeTo(boolean queryResult, Object[] objects, MediaType baseMediaType, MultivaluedMap<String, Object> map, OutputStream outputStream) throws WebApplicationException {
        boolean isClientSide = false;
        try {
            this.httpServletRequest.getMethod();
        }
        catch (RuntimeException e) {
            isClientSide = true;
        }
        String descriptionURI = null;
        Object responseInfoURI = null;
        if (queryResult && !isClientSide) {
            log.trace("Marshalling response objects as OSLC Query result (server-side only)");
            String method = this.httpServletRequest.getMethod();
            if ("GET".equals(method)) {
                descriptionURI = OSLC4JUtils.resolveURI((HttpServletRequest)this.httpServletRequest, (boolean)true);
                responseInfoURI = descriptionURI;
                String queryString = this.httpServletRequest.getQueryString();
                if (queryString != null && ProviderHelper.isOslcQuery(queryString)) {
                    responseInfoURI = (String)responseInfoURI + "?" + queryString;
                }
            }
        }
        String serializationLanguage = this.getSerializationLanguage(baseMediaType);
        Map properties = isClientSide ? null : (Map)this.httpServletRequest.getAttribute("org.eclipse.lyo.oslc4j.selected.properties");
        String nextPageURI = isClientSide ? null : (String)this.httpServletRequest.getAttribute("org.eclipse.lyo.oslc4j.next.page");
        Integer totalCount = isClientSide ? null : (Integer)this.httpServletRequest.getAttribute("org.eclipse.lyo.oslc4j.total.count");
        ResponseInfoArray responseInfo = new ResponseInfoArray(null, properties, totalCount, nextPageURI);
        this.writeObjectsTo(objects, outputStream, properties, descriptionURI, (String)responseInfoURI, (ResponseInfo<?>)responseInfo, serializationLanguage);
    }

    private String getSerializationLanguage(MediaType baseMediaType) {
        if (baseMediaType == null) {
            throw new IllegalArgumentException("Base media type can't be null");
        }
        ArrayList<AbstractMap.SimpleEntry<MediaType, String>> mediaPairs = new ArrayList<AbstractMap.SimpleEntry<MediaType, String>>();
        mediaPairs.add(new AbstractMap.SimpleEntry<MediaType, String>(OslcMediaType.TEXT_TURTLE_TYPE, "Turtle"));
        mediaPairs.add(new AbstractMap.SimpleEntry<MediaType, String>(OslcMediaType.APPLICATION_JSON_LD_TYPE, "JSON-LD"));
        if (OSLC4JUtils.alwaysAbbrevXML()) {
            mediaPairs.add(new AbstractMap.SimpleEntry<MediaType, String>(OslcMediaType.APPLICATION_RDF_XML_TYPE, "RDF/XML-ABBREV"));
        } else {
            mediaPairs.add(new AbstractMap.SimpleEntry<MediaType, String>(OslcMediaType.APPLICATION_RDF_XML_TYPE, "RDF/XML"));
        }
        mediaPairs.add(new AbstractMap.SimpleEntry<MediaType, String>(OslcMediaType.APPLICATION_XML_TYPE, "RDF/XML-ABBREV"));
        mediaPairs.add(new AbstractMap.SimpleEntry<MediaType, String>(OslcMediaType.TEXT_XML_TYPE, "RDF/XML"));
        for (Map.Entry entry : mediaPairs) {
            if (!baseMediaType.isCompatible((MediaType)entry.getKey())) continue;
            log.trace("Using '{}' writer for '{}' Accept media type", entry.getValue(), entry.getKey());
            return (String)entry.getValue();
        }
        throw new IllegalArgumentException("Base media type can't be matched to any writer");
    }

    protected Object[] readFrom(Class<?> type, MediaType mediaType, MultivaluedMap<String, String> map, InputStream inputStream) throws WebApplicationException {
        Model model = ModelFactory.createDefaultModel();
        RDFReaderI reader = this.getRdfReader(mediaType, model);
        try {
            reader.read(model, inputStream, "");
            return JenaModelHelper.unmarshal((Model)model, type);
        }
        catch (Exception exception) {
            throw new WebApplicationException((Throwable)exception, this.buildBadRequestResponse(exception, mediaType, map));
        }
    }

    private RDFReaderI getRdfReader(MediaType mediaType, Model model) {
        String language = this.getSerializationLanguage(mediaType);
        RDFReaderI reader = language.equals("RDF/XML-ABBREV") ? model.getReader() : model.getReader(language);
        reader.setErrorHandler((RDFErrorHandler)ERROR_HANDLER);
        return reader;
    }

    protected Response buildBadRequestResponse(Exception exception, MediaType initialErrorMediaType, MultivaluedMap<String, ?> map) {
        MediaType determinedErrorMediaType = this.determineErrorMediaType(initialErrorMediaType, map);
        Error error = new Error();
        error.setStatusCode(String.valueOf(Response.Status.BAD_REQUEST.getStatusCode()));
        error.setMessage(exception.getMessage());
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
        return responseBuilder.type(determinedErrorMediaType).entity((Object)error).build();
    }

    private MediaType determineErrorMediaType(MediaType initialErrorMediaType, MultivaluedMap<String, ?> map) {
        block5: {
            try {
                List acceptableMediaTypes = this.httpHeaders.getAcceptableMediaTypes();
                if (acceptableMediaTypes != null) {
                    for (MediaType acceptableMediaType : acceptableMediaTypes) {
                        if (!this.isAcceptableMediaType(acceptableMediaType)) continue;
                        return acceptableMediaType;
                    }
                }
            }
            catch (NullPointerException exception) {
                Object acceptObject;
                if (map == null || !((acceptObject = map.getFirst((Object)"Accept")) instanceof String)) break block5;
                String[] accepts = acceptObject.toString().split(",");
                double winningQ = 0.0;
                MediaType winningMediaType = null;
                for (String accept : accepts) {
                    double q;
                    MediaType acceptMediaType = MediaType.valueOf((String)accept);
                    if (!this.isAcceptableMediaType(acceptMediaType)) continue;
                    String stringQ = (String)acceptMediaType.getParameters().get("q");
                    double d = q = stringQ == null ? 1.0 : Double.parseDouble(stringQ);
                    if (Double.compare(q, 0.0) <= 0 || winningMediaType != null && Double.compare(q, winningQ) <= 0) continue;
                    winningMediaType = acceptMediaType;
                    winningQ = q;
                }
                if (winningMediaType == null) break block5;
                return winningMediaType;
            }
        }
        return initialErrorMediaType;
    }

    private boolean isAcceptableMediaType(MediaType mediaType) {
        return !mediaType.isWildcardType() && !mediaType.isWildcardSubtype() && this.providers.getMessageBodyWriter(CLASS_OSLC_ERROR, CLASS_OSLC_ERROR, ANNOTATIONS_EMPTY_ARRAY, mediaType) != null;
    }
}

