/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.internal.assist;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.fieldassist.IContentProposal;

public class TypeContentProposal
implements IContentProposal {
    private final EClassifier proposal;
    private final String incomplete;

    public TypeContentProposal(EClassifier proposal, String incomplete) {
        this.proposal = proposal;
        this.incomplete = incomplete;
    }

    public String getContent() {
        String content = this.getLabel().substring(this.incomplete.length());
        return content;
    }

    public int getCursorPosition() {
        return this.getLabel().length() + 1;
    }

    public String getDescription() {
        Resource proposalResource;
        String mmURI;
        String description = this.getLabel();
        String doc = EcoreUtil.getDocumentation((EModelElement)this.proposal);
        if (doc != null) {
            description = String.valueOf(description) + "\n " + doc;
        }
        if ((mmURI = this.proposal.getEPackage().getNsURI()) != null) {
            description = String.valueOf(description) + "\nin " + mmURI;
        }
        if ((proposalResource = this.proposal.eResource()) != null && proposalResource.getURI() != null) {
            String resourceURI = proposalResource.getURI().toString();
            if (mmURI != null && !resourceURI.equals(mmURI)) {
                description = String.valueOf(description) + "\nlocated at " + resourceURI;
            }
        }
        return description;
    }

    public String getLabel() {
        String label = this.proposal.getName();
        String pkgName = this.proposal.getEPackage().getName();
        if (pkgName != null) {
            String separator = "::";
            if (this.incomplete.startsWith(String.valueOf(pkgName) + ":")) {
                separator = "::";
            } else if (this.incomplete.startsWith(String.valueOf(pkgName) + ".")) {
                separator = ".";
            }
            String fullyQualifiedProposal = String.valueOf(pkgName) + separator + this.proposal.getName();
            if (fullyQualifiedProposal.startsWith(this.incomplete)) {
                label = fullyQualifiedProposal;
            }
        }
        return label;
    }
}

